# 🚀 Swisser-Web-03 - Premium FiveM RP Server Website Template

<div align="center">
  <img src="https://img.shields.io/badge/React-19.1-61dafb?style=for-the-badge&logo=react&logoColor=white" alt="React">
  <img src="https://img.shields.io/badge/TypeScript-5.8-3178c6?style=for-the-badge&logo=typescript&logoColor=white" alt="TypeScript">
  <img src="https://img.shields.io/badge/Vite-7.1-646cff?style=for-the-badge&logo=vite&logoColor=white" alt="Vite">
  <img src="https://img.shields.io/badge/TailwindCSS-3.4-06b6d4?style=for-the-badge&logo=tailwindcss&logoColor=white" alt="TailwindCSS">
</div>

<div align="center">
  <h3>Transform Your FiveM Server's Online Presence</h3>
  <p>The ultimate street-inspired website template that converts visitors into loyal players</p>
  <a href="https://swisser.dev/discord"><strong>Get Support on Discord »</strong></a>
</div>

---

## 🎯 Why Choose Swisser-Web-03?

Your FiveM server deserves more than a generic website. **Swisser-Web-03** delivers the raw, authentic street aesthetic that resonates with the GTA roleplay community. This isn't just another template—it's your server's digital identity.

Watch your player count grow as visitors are captivated by smooth animations, live server stats, and a design that screams quality from the first second.

## ✨ Key Features That Set You Apart

### 🎨 **Street-Inspired Brutal Design**
- Authentic urban aesthetic with graffiti elements
- Police tape transitions and mugshot-style team cards
- Polaroid gallery with scattered photo effects
- Dark theme optimized for the gaming community

### ⚡ **Performance That Delivers**
- Lightning-fast load times with Vite 7.1
- Live player count updates every 30 seconds
- One-click FiveM server connection
- GitHub Pages ready—deploy in minutes

### 🛠️ **Built for Real Developers**
- Clean, maintainable React components
- Full TypeScript support with zero errors
- Tailwind CSS for rapid customization
- Professional CI/CD pipeline included

### 📱 **Everything Your Server Needs**
- **Hero Section** - Stunning landing with live server status
- **Features Grid** - Showcase your unique selling points
- **Jobs System** - Display roles with salary ranges
- **Rules Section** - Organized by category and severity
- **Team Showcase** - Mugshot-style staff presentation
- **Media Gallery** - Polaroid-style screenshots
- **Legal Pages** - GDPR-compliant privacy policy
- **Bottom Navigation** - Mobile-friendly with server stats

## 🚀 Get Started in 3 Minutes

```bash
# Clone the template
git clone https://github.com/SwisserDev/swisser-web-03.git

# Install and run
cd swisser-web-03
npm install
npm run dev
```

Your site is now live at `http://localhost:5173` ✨

## 🌐 Deploy to GitHub Pages

Push your code and let GitHub Actions handle the rest:

```bash
git push origin main
```

Your site automatically deploys to: `https://[username].github.io/[repo-name]/`

## 🎮 FiveM Integration That Works

### Connect Your Server in 30 Seconds

1. Find your server on [servers.fivem.net](https://servers.fivem.net)
2. Copy your server code from the URL
3. Add it to `site.config.json`:

```json
"api": {
  "serverCode": "ymkax5"  // Your code here
}
```

That's it! Your site now shows:
- ✅ Live player count
- ✅ Server online/offline status
- ✅ Direct connect button
- ✅ Auto-refresh every 30 seconds

## 🎨 Make It Yours

### Simple Configuration
Everything is in one file: `src/config/site.config.json`
- Server details and branding
- Team members and roles
- Jobs and salaries
- Rules and categories
- Social media links
- Every single text label

### Professional Image Hosting
All images are hosted on Unsplash CDN:
- No GitHub Pages path issues
- Faster loading from global CDN
- Professional stock photos included
- Just replace URLs to customize

## 💪 What Makes V3 Special?

### The Street Aesthetic
- Brutal design with urban elements
- Graffiti tags and spray paint effects
- Police tape and fingerprint patterns
- Torn paper transitions between sections

### Production-Ready Code
- Clean, professional codebase
- Build runs without warnings
- TypeScript fully configured
- Comprehensive .gitignore

### Developer Experience
- One-command deployment
- Automated GitHub Actions
- Type-safe development
- Modern React 19.1

## 🛠️ Tech Stack

- **React 19.1** - Latest and greatest
- **TypeScript** - Type-safe by default
- **Vite 7.1** - Instant HMR
- **Tailwind CSS** - Style at the speed of thought
- **GSAP** - Hollywood-grade animations
- **Framer Motion** - Smooth as butter

## 📦 Clean Project Structure

```
swisser-web-03/
├── .github/workflows/    # Automated deployment
├── src/
│   ├── components/       # Modular components
│   ├── config/          # Single config file
│   └── pages/           # Route pages
├── public/              # Static assets
└── DEPLOYMENT.md        # Complete guide
```

## 🤝 Join the Swisser Community

We're not just selling templates—we're building a community of successful FiveM servers.

### Get Direct Support
- 💬 **Discord**: [swisser.dev/discord](https://swisser.dev/discord)
- 📧 **Email**: support@swisser.dev
- 🌐 **Website**: [swisser.dev](https://swisser.dev)

### What You Get:
- Direct support from our team
- Free updates and improvements
- Network with other server owners
- Early access to new templates

## 💝 Support the Project

If Swisser-Web-03 helps your server grow:
- ⭐ Star this repo
- 🔄 Share with friends
- 💬 Join our Discord
- ☕ Buy us a coffee

---

<div align="center">
  <h3>Ready to Level Up Your Server?</h3>
  <p>Join hundreds of successful FiveM servers using Swisser templates</p>
  <a href="https://swisser.dev/discord"><strong>Get Started Now →</strong></a>
  <br><br>
  <i>Built with ❤️ by Swisser Development</i>
</div>